/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.fideicomiso;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.BeneficioRetencion;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class Fideicomiso
extends ObjetoModeloSucesorValidableAnotado<Iva>
implements InformacionEditable<Fideicomiso> {
    private static final long serialVersionUID = -8426933311037749760L;
    public static final String C_RUC_FIDEICOMISO = "rucFideicomiso";
    public static final String C_TIPO_FIDEICOMISO = "tipoFideicomiso";
    public static final String C_MONTO_BENEFICIO_TOTAL = "montoBeneficioTotal";
    public static final String CC_BENEFICIOS_RETENCION = "beneficiosRetencion";
    private static final String M_RUC_FID = "RUC del Fideicomiso";
    private static final String M_BENF_TOT = "Monto Beneficio Total";
    @NotNull(message="Debe ingresar el valor de RUC del Fideicomiso")
    private String rucFideicomiso;
    @NotNull(message="Debe seleccionar el tipo de Tipo de Fideicomiso")
    private String tipoFideicomiso;
    private String descripcionTipoFideicomiso;
    @NotNull(message="Debe ingresar el valor de Monto Beneficio Total")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto Beneficio Total debe ser 12 enteros y 2 decimales. ")
    private String montoBeneficioTotal = "0.00";
    private List<BeneficioRetencion> beneficiosRetencion = new ArrayList<BeneficioRetencion>();
    private BigDecimal totalBeneficioRetencionIndividual = BigDecimal.ZERO;
    private transient boolean fideicomisoRepetido = false;

    public List<BeneficioRetencion> getBeneficiosRetencion() {
        return this.beneficiosRetencion;
    }

    public void agregarBeneficioRetencion(BeneficioRetencion beneficioRetencion) {
        beneficioRetencion.setPropietario((ObjetoModelo)this);
        this.beneficiosRetencion.add(beneficioRetencion);
        this.sumarBeneficioIndividualEdicion(beneficioRetencion);
        this.firePropertyChange(CC_BENEFICIOS_RETENCION, null, this.beneficiosRetencion);
    }

    public boolean eliminarBeneficioRetencion(BeneficioRetencion beneficioRetencion) {
        boolean eliminado = this.beneficiosRetencion.remove((Object)beneficioRetencion);
        if (eliminado) {
            this.restarBeneficioIndividualEdicion(beneficioRetencion);
            this.firePropertyChange(CC_BENEFICIOS_RETENCION, null, this.beneficiosRetencion);
        }
        return eliminado;
    }

    public void restarBeneficioIndividualEdicion(BeneficioRetencion beneficioRetencion) {
        this.totalBeneficioRetencionIndividual = this.totalBeneficioRetencionIndividual.subtract(Util.getBigDecimal(beneficioRetencion.getMontoBeneficioIndividual()));
    }

    public void sumarBeneficioIndividualEdicion(BeneficioRetencion beneficioRetencion) {
        this.totalBeneficioRetencionIndividual = this.totalBeneficioRetencionIndividual.add(Util.getBigDecimal(beneficioRetencion.getMontoBeneficioIndividual()));
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        ValidacionIdentificacion.validarTodaIdentificacion((String)"R", (String)this.getRucFideicomiso(), (ResultadoValidacion)resultado, (Integer)0, (Integer)0);
        if (this.validarMontoTotal(resultado).esEstadoFallido()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public Fideicomiso crearCopiaEdicion() {
        Fideicomiso copia = new Fideicomiso();
        copia.setRucFideicomiso(this.rucFideicomiso);
        copia.setTipoFideicomiso(this.tipoFideicomiso);
        copia.setDescripcionTipoFideicomiso(this.descripcionTipoFideicomiso);
        copia.setMontoBeneficioTotal(this.montoBeneficioTotal);
        copia.setTotalBeneficioRetencionIndividual(this.totalBeneficioRetencionIndividual);
        copia.setPropietario((Iva)this.propietario);
        return copia;
    }

    public void actualizarInformacion(Fideicomiso copiaEdicion) {
        this.setRucFideicomiso(copiaEdicion.getRucFideicomiso());
        this.setTipoFideicomiso(copiaEdicion.getTipoFideicomiso());
        this.setDescripcionTipoFideicomiso(copiaEdicion.getDescripcionTipoFideicomiso());
        this.setMontoBeneficioTotal(copiaEdicion.getMontoBeneficioTotal());
    }

    private ResultadoValidacion validarMontoTotal(ResultadoValidacion resultado) {
        if (this.getTotalBeneficioRetencionIndividual().compareTo(Util.getBigDecimal(this.getMontoBeneficioTotal())) == 1) {
            return resultado.fallarValidacion("El valor Monto del Beneficio Total no puede ser menor al valor Monto del Beneficio Individual");
        }
        return resultado;
    }

    public String getRucFideicomiso() {
        return this.rucFideicomiso;
    }

    public String getTipoFideicomiso() {
        return this.tipoFideicomiso;
    }

    public String getDescripcionTipoFideicomiso() {
        return this.descripcionTipoFideicomiso;
    }

    public String getMontoBeneficioTotal() {
        return this.montoBeneficioTotal;
    }

    public boolean isFideicomisoRepetido() {
        return this.fideicomisoRepetido;
    }

    public BigDecimal getTotalBeneficioRetencionIndividual() {
        return this.totalBeneficioRetencionIndividual;
    }

    public void setRucFideicomiso(String rucFideicomiso) {
        String oldValue = this.rucFideicomiso;
        this.rucFideicomiso = StringUtil.isNullOrEmpty((String)rucFideicomiso) ? rucFideicomiso : rucFideicomiso.toUpperCase();
        this.firePropertyChange(C_RUC_FIDEICOMISO, oldValue, this.rucFideicomiso);
    }

    public void setTipoFideicomiso(String tipoFideicomiso) {
        String oldValue = this.tipoFideicomiso;
        this.tipoFideicomiso = StringUtil.isNullOrEmpty((String)tipoFideicomiso) ? tipoFideicomiso : tipoFideicomiso.toUpperCase();
        this.firePropertyChange(C_TIPO_FIDEICOMISO, oldValue, this.tipoFideicomiso);
    }

    public void setDescripcionTipoFideicomiso(String descripcionTipoFideicomiso) {
        this.descripcionTipoFideicomiso = descripcionTipoFideicomiso;
    }

    public void setMontoBeneficioTotal(String montoBeneficioTotal) {
        String oldValue = this.montoBeneficioTotal;
        this.montoBeneficioTotal = montoBeneficioTotal;
        this.firePropertyChange(C_MONTO_BENEFICIO_TOTAL, oldValue, this.montoBeneficioTotal);
    }

    public void setFideicomisoRepetido(boolean fideicomisoRepetido) {
        this.fideicomisoRepetido = fideicomisoRepetido;
    }

    private void setTotalBeneficioRetencionIndividual(BigDecimal totalBeneficioRetencionIndividual) {
        this.totalBeneficioRetencionIndividual = totalBeneficioRetencionIndividual;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.rucFideicomiso == null ? 0 : this.rucFideicomiso.hashCode());
        result = 31 * result + (this.tipoFideicomiso == null ? 0 : this.tipoFideicomiso.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Fideicomiso other = (Fideicomiso)((Object)obj);
        if (this.rucFideicomiso == null ? other.rucFideicomiso != null : !this.rucFideicomiso.equals(other.rucFideicomiso)) {
            return false;
        }
        return !(this.tipoFideicomiso == null ? other.tipoFideicomiso != null : !this.tipoFideicomiso.equals(other.tipoFideicomiso));
    }
}

